<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="container py-5">
    <div class="row">
        <!-- Main Content -->
        <div class="col-lg-8 mb-4">
            <article class="card shadow-sm border-0">
                <!-- Featured Image -->
                <?php if (!empty($post->featured_image)): ?>
                    <img src="<?php echo base_url('uploads/blog/' . $post->featured_image); ?>" 
                         class="card-img-top" 
                         alt="<?php echo htmlspecialchars($post->title); ?>"
                         style="max-height: 500px; object-fit: cover;">
                <?php endif; ?>
                
                <div class="card-body p-4 p-md-5">
                    <!-- Category & Date -->
                    <div class="mb-3">
                        <?php if (!empty($post->category_name)): ?>
                            <a href="<?php echo base_url('blog/category/' . $post->category_slug); ?>" 
                               class="badge bg-primary text-decoration-none me-2">
                                <?php echo htmlspecialchars($post->category_name); ?>
                            </a>
                        <?php endif; ?>
                        <small class="text-muted">
                            <i class="far fa-calendar"></i>
                            <?php echo date('F d, Y', strtotime($post->published_at)); ?>
                        </small>
                        <small class="text-muted ms-3">
                            <i class="far fa-eye"></i>
                           <?php echo number_format($post->views_count ?? 0); ?> views
                        </small>
                    </div>
                    
                    <!-- Title -->
                    <h1 class="fw-bold mb-3"><?php echo htmlspecialchars($post->title); ?></h1>
                    
                    <!-- Author Info -->
                    <div class="d-flex align-items-center mb-4 pb-3 border-bottom">
                        <div class="rounded-circle bg-primary d-flex align-items-center justify-content-center me-3"
                             style="width: 50px; height: 50px;">
                            <span class="text-white fw-bold">
                                <?php echo strtoupper(substr($post->author_name, 0, 1)); ?>
                            </span>
                        </div>
                        <div>
                            <h6 class="mb-0 fw-bold"><?php echo htmlspecialchars($post->author_name); ?></h6>
                            <small class="text-muted">Author</small>
                        </div>
                    </div>
                    
                    <!-- Post Content -->
                    <div class="post-content">
                        <?php echo $post->content; ?>
                    </div>
                    
                    <!-- Tags (if available) -->
                    <?php if (!empty($post->tags)): ?>
                        <div class="mt-4 pt-4 border-top">
                            <h6 class="fw-bold mb-3">Tags:</h6>
                            <?php 
                            $tags = explode(',', $post->tags);
                            foreach ($tags as $tag): 
                            ?>
                                <span class="badge bg-light text-dark me-2 mb-2">
                                    <i class="fas fa-tag"></i> <?php echo trim(htmlspecialchars($tag)); ?>
                                </span>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Share Buttons -->
                    <div class="mt-4 pt-4 border-top">
                        <h6 class="fw-bold mb-3">Share this article:</h6>
                        <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo current_url(); ?>" 
                           target="_blank" 
                           class="btn btn-sm btn-outline-primary me-2 mb-2">
                            <i class="fab fa-facebook-f"></i> Facebook
                        </a>
                        <a href="https://twitter.com/intent/tweet?url=<?php echo current_url(); ?>&text=<?php echo urlencode($post->title); ?>" 
                           target="_blank" 
                           class="btn btn-sm btn-outline-info me-2 mb-2">
                            <i class="fab fa-twitter"></i> Twitter
                        </a>
                        <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo current_url(); ?>" 
                           target="_blank" 
                           class="btn btn-sm btn-outline-primary me-2 mb-2">
                            <i class="fab fa-linkedin-in"></i> LinkedIn
                        </a>
                        <a href="https://wa.me/?text=<?php echo urlencode($post->title . ' ' . current_url()); ?>" 
                           target="_blank" 
                           class="btn btn-sm btn-outline-success mb-2">
                            <i class="fab fa-whatsapp"></i> WhatsApp
                        </a>
                    </div>
                </div>
            </article>
            
            <!-- Related Posts -->
            <?php if (!empty($related_posts)): ?>
                <div class="mt-5">
                    <h3 class="fw-bold mb-4">Related Articles</h3>
                    <div class="row">
                        <?php foreach ($related_posts as $related): ?>
                            <div class="col-md-4 mb-3">
                                <div class="card h-100 shadow-sm border-0">
                                    <a href="<?php echo base_url('blog/view/' . $related->slug); ?>">
                                        <?php if (!empty($related->featured_image)): ?>
                                            <img src="<?php echo base_url('uploads/blog/' . $related->featured_image); ?>" 
                                                 class="card-img-top" 
                                                 alt="<?php echo htmlspecialchars($related->title); ?>"
                                                 style="height: 150px; object-fit: cover;">
                                        <?php else: ?>
                                            <div class="card-img-top bg-light d-flex align-items-center justify-content-center" 
                                                 style="height: 150px;">
                                                <i class="fas fa-newspaper fa-2x text-muted"></i>
                                            </div>
                                        <?php endif; ?>
                                    </a>
                                    <div class="card-body">
                                        <h6 class="card-title">
                                            <a href="<?php echo base_url('blog/view/' . $related->slug); ?>" 
                                               class="text-decoration-none text-dark">
                                                <?php echo htmlspecialchars(character_limiter($related->title, 60)); ?>
                                            </a>
                                        </h6>
                                        <small class="text-muted">
                                            <i class="far fa-calendar"></i>
                                            <?php echo date('M d, Y', strtotime($related->published_at)); ?>
                                        </small>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        
        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Back to Blog -->
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-body">
                    <a href="<?php echo base_url('blog'); ?>" class="btn btn-outline-primary w-100">
                        <i class="fas fa-arrow-left"></i> Back to Blog
                    </a>
                </div>
            </div>
            
            <!-- Call to Action -->
            <div class="card shadow-sm border-0 mb-4" style="background: linear-gradient(135deg, #f26124, #8105bf);">
                <div class="card-body text-white text-center p-4">
                    <h5 class="fw-bold mb-3">Get Involved</h5>
                    <p class="mb-3">Join our community and make a difference!</p>
                    <a href="<?php echo base_url('volunteer/apply'); ?>" class="btn btn-light w-100 mb-2">
                        <i class="fas fa-hands-helping"></i> Volunteer
                    </a>
                    <a href="<?php echo base_url('donate'); ?>" class="btn btn-outline-light w-100">
                        <i class="fas fa-heart"></i> Donate
                    </a>
                </div>
            </div>
            
            <!-- Categories Widget (if available) -->
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Explore More</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <a href="<?php echo base_url('workshops'); ?>" class="text-decoration-none">
                                <i class="fas fa-chalkboard-teacher text-primary"></i> Our Workshops
                            </a>
                        </li>
                        <li class="mb-2">
                            <a href="<?php echo base_url('about'); ?>" class="text-decoration-none">
                                <i class="fas fa-info-circle text-primary"></i> About Us
                            </a>
                        </li>
                        <li class="mb-2">
                            <a href="<?php echo base_url('partners'); ?>" class="text-decoration-none">
                                <i class="fas fa-handshake text-primary"></i> Our Partners
                            </a>
                        </li>
                        <li class="mb-0">
                            <a href="<?php echo base_url('contact'); ?>" class="text-decoration-none">
                                <i class="fas fa-envelope text-primary"></i> Contact Us
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.post-content {
    font-size: 1.1rem;
    line-height: 1.8;
}

.post-content p {
    margin-bottom: 1.5rem;
}

.post-content img {
    max-width: 100%;
    height: auto;
    border-radius: 8px;
    margin: 1.5rem 0;
}

.post-content h2 {
    font-size: 1.8rem;
    font-weight: 700;
    margin-top: 2rem;
    margin-bottom: 1rem;
    color: #f26124;
}

.post-content h3 {
    font-size: 1.5rem;
    font-weight: 600;
    margin-top: 1.5rem;
    margin-bottom: 1rem;
}

.post-content ul, .post-content ol {
    margin-bottom: 1.5rem;
    padding-left: 2rem;
}

.post-content blockquote {
    border-left: 4px solid #f26124;
    padding-left: 1.5rem;
    margin: 1.5rem 0;
    font-style: italic;
    color: #666;
}
</style>